# サムネイルのテスト
#
# ウィンドウ -> タブ -> 項目 を列挙したメニューを表示します。

import PictureFan as PF

app = PF.Application()

menu = PF.PopupMenu()
menu.add("active", "Active Window")
menu.add("sep", "")

# ウィンドウの列挙
window_count = app.thumbnails_window_count
for i in range(window_count):
    menu.add(str(i), "Window " + str(i))

result = menu.show()
if result == "active":
    window = app.get_active_thumbnails_window()
elif result != "":
    window = app.get_thumbnails_window(int(result))
else:
    window = None

if window is not None:
    app.alert("Selected windows is : " + window.title)

    menu.clear()
    menu.add("active", "Active Folder")
    menu.add("sep", "")

    # タブの列挙
    folder_count = window.folder_count
    for i in range(folder_count):
        folder = window.get_folder(i)
        menu.add(str(i), folder.display_name)

    result = menu.show()
    if result == "active":
        folder = window.get_active_folder()
    elif result != "":
        folder = window.get_folder(int(result))
    else:
        folder = None

    if folder is not None:
        app.alert("Selected folder is : " + folder.display_name)
        menu.clear()

        # 項目の列挙
        file_count = folder.file_count
        for i in range(file_count):
            f = folder.get_file(i)
            menu.add(str(i), f.display_name)

        result = menu.show()
        if result != "":
            item = folder.get_file(int(result))
            app.alert("Selected item is : " + item.display_name)
