# ドキュメントにユーザープロパティのタグを設定する
#
# アクティブなドキュメントのタグに #Test を追加します。

import PictureFan as PF

app = PF.Application()

# 現在アクティブなドキュメントを取得する
doc = app.get_current_document()

if doc is not None:
    # 現在のタグを取得する
    tags = doc.get_user_property("tags")

    if tags is not None:
        # 既にタグが存在するなら追加
        tags += "#Test"
    else:
        tags = "#Test"

    # タグを設定する
    doc.set_user_property("tags", tags)
