# Pillow(PIL) を利用するサンプル

import PictureFan as PF
from PIL import Image, ImageFilter

app = PF.Application()

# 現在の画像を取得する
img = app.get_current_image()

# 画像をRGB8ビットに変換する
img_rgb = img.to_rgb8()

# Pillow の画像を作成する
pil_img = Image.frombytes("RGB", (img_rgb.width, img_rgb.height), img_rgb.to_bytes(), "raw")

# Pillow で画像処理を行う
blur_img = pil_img.filter(ImageFilter.BLUR)

# Pillow の画像から PictureFan の画像を作成する
img.from_bytes(blur_img.width, blur_img.height, PF.Colorspace.RGB, 8, 3, blur_img.tobytes())

# 現在の画像に設定する
app.set_current_image(img, "Blur")
