# サムネイルの項目にユーザープロパティのタグを設定する
#
# 選択されている項目のタグに #Test を追加します。

import PictureFan as PF

app = PF.Application()

window = app.get_active_thumbnails_window()

if window is not None:
    folder = window.get_active_folder()
    if folder is not None:
        file_count = folder.file_count
        for i in range(file_count):
            f = folder.get_file(i)
            if f.selected:
                # 現在のタグを取得する
                tags = f.get_user_property("tags")
                if tags is not None:
                    # 既にタグが存在するなら追加
                    tags += "#Test"
                else:
                    tags = "#Test"
                # タグを設定する
                f.set_user_property("tags", tags)
